/*
	DevSaver Web Framework
	Copyright (c) 2013-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/

var STBGalleryEffectsG7 = Object.create(STBModule.prototype);

STBGalleryEffectsG7.name = "GalleryEffectsG7";
STBGalleryEffectsG7.resetDone = function() {
	$('.gallery-element-7.__done').removeClass("__done");
}

STBGalleryEffectsG7.getOverlayPosition = function() {
	var overlayText = $('.gallery-element-7:not(.__done)').find('.overlay-text');

	if (overlayText.length > 0) {
		var parseGallery = function () {

			var obj = $(this),
				galleryElementHeight = obj.parent().parent().outerHeight(),
				overlayHeight = obj.outerHeight(),
				projectTitle = obj.parent().parent().find('.project-title'),
				projectTitleHeight = projectTitle.outerHeight(),
				projectTitlePosition = projectTitle.css('top'),
				realProjectTitlePosition = parseInt(projectTitlePosition, 10),
				totalHeightTitle = projectTitleHeight + realProjectTitlePosition,
				restHeight = galleryElementHeight - totalHeightTitle,
				semiRestHeight = restHeight - overlayHeight,
				demiRestHeight = semiRestHeight / 2,
				paddingOverlay = totalHeightTitle + demiRestHeight;

			obj.css('padding-top', paddingOverlay);
			obj.addClass("__done");
		};

		overlayText.each(parseGallery);
	}
}



STBGalleryEffectsG7.runOnLoad = function() {
	STBGalleryEffectsG7.getOverlayPosition();
}

STBGalleryEffectsG7.runOnContentUpdate = function() {
	STBGalleryEffectsG7.getOverlayPosition();
}

STBGalleryEffectsG7.runOnResize = function() {
	STBGalleryEffectsG7.resetDone();
	STBGalleryEffectsG7.getOverlayPosition();
}

site.registerModule(STBGalleryEffectsG7);
